#include <bits/stdc++.h>
using namespace std;

struct Trie {
    array<int,10> nxt;
    bool mark = false;
    long long val = 0;
    Trie(){ nxt.fill(-1); }
};

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n; cin >> n;
    vector<long long> a(n);
    for(int i=0;i<n;++i) cin >> a[i];

    vector<Trie> trie(1);

    // вставка чисел у Trie
    for(long long x: a){
        string s = to_string(x);
        int cur = 0;
        for(char c: s){
            int d = c - '0';
            if(trie[cur].nxt[d] == -1){
                trie[cur].nxt[d] = trie.size();
                trie.emplace_back();
            }
            cur = trie[cur].nxt[d];
        }
        trie[cur].mark = true;
        trie[cur].val = x;
    }

    // нумерація маркованих вузлів
    unordered_map<int,int> id;
    vector<int> marked;
    for(int i=0;i<(int)trie.size();++i)
        if(trie[i].mark){
            id[i] = marked.size();
            marked.push_back(i);
        }
    int m = marked.size();

    vector<vector<int>> adj(m);

    // DFS для побудови ребер між найближчими маркованими
    function<void(int,int)> dfs = [&](int v, int last){
        int cur = last;
        if(trie[v].mark){
            int myid = id[v];
            if(cur != -1) adj[cur].push_back(myid);
            cur = myid;
        }
        for(int d=0; d<10; ++d){
            int to = trie[v].nxt[d];
            if(to != -1) dfs(to, cur);
        }
    };
    dfs(0,-1);

    // двочастковий граф для парування
    vector<int> mtL(m,-1), mtR(m,-1);
    function<bool(int,vector<char>&)> kuhn = [&](int v, vector<char>& used){
        if(used[v]) return false;
        used[v]=1;
        for(int to: adj[v]){
            if(mtR[to]==-1 || kuhn(mtR[to],used)){
                mtL[v]=to; mtR[to]=v;
                return true;
            }
        }
        return false;
    };

    int match=0;
    for(int v=0; v<m; ++v){
        vector<char> used(m,0);
        if(kuhn(v,used)) ++match;
    }

    int k = m - match;
    cout << k << "\n";

    // відновлення шляхів
    vector<char> has_in(m,0), vis(m,0);
    for(int r=0;r<m;++r) if(mtR[r]!=-1) has_in[r]=1;

    vector<long long> id2val(m);
    for(auto &p:id) id2val[p.second]=trie[p.first].val;

    for(int v=0; v<m; ++v){
        if(!has_in[v]){
            vector<long long> path;
            int cur=v;
            while(cur!=-1 && !vis[cur]){
                vis[cur]=1;
                path.push_back(id2val[cur]);
                cur=mtL[cur];
            }
            cout<<path.size()<<"\n";
            for(long long x:path) cout<<x<<" ";
            cout<<"\n";
        }
    }
    // якщо лишились непокриті (страховка)
    for(int v=0; v<m; ++v) if(!vis[v]){
        cout<<1<<"\n"<<id2val[v]<<"\n";
    }
}